"""Simple program to demo how to use meshtastic library.
   To run: python examples/info.py
"""

import meshtastic
import meshtastic.serial_interface
import json
import base64
from meshtastic.util import fromPSK

interface = meshtastic.serial_interface.SerialInterface()

# call showInfo() just to ensure values are populated
print(interface.myInfo)
print(interface.metadata)
#print(json.dumps(interface.nodesByNum, indent=2))

node = interface.getNode('^local')
#node.setOwner("TESTT", "000", False)
# how to disable encryption
#print(node.channels[0].settings.psk)
#node.channels[0].settings.psk = fromPSK("none")
#print("Writing modified channels to device")
##node.writeChannel(0)
"""
# you should actually use this!
if interface.nodes:
    for node in interface.nodes.values():
        if node["num"] == interface.myInfo.my_node_num:
            print("this is your node!")
            print(node["user"]["hwModel"])
            continue

        if node.get('num'):
            print(node["num"])

        if node.get('user'):
            print("Node ID: " + str(node["user"]["id"]))
            print(node["user"]["longName"])
            print(node["user"]["shortName"])
            if node.get("user", {}).get("hwModel"):
                print(node["user"]["hwModel"])
            if node.get("user", {}).get("role"):
                print(node["user"]["role"])

        if node.get('snr'):
            print(node["snr"])

        if node.get('lastHeard'):
            print(node["lastHeard"])

        if node.get('hopsAway'):
            print("Hops Away: " + str(node["hopsAway"]))

        if node.get('deviceMetrics'):
            if node.get("deviceMetrics", {}).get("channelUtilization"):
                print("Channel Utilization: " + str(node["deviceMetrics"]["channelUtilization"]))

            if node.get("deviceMetrics", {}).get("batteryLevel"):
                print(node["deviceMetrics"]["batteryLevel"])

            if node.get("deviceMetrics", {}).get("voltage"):
                print(node["deviceMetrics"]["voltage"])

            if node.get("deviceMetrics", {}).get("airUtilTx"):
                print(node["deviceMetrics"]["airUtilTx"])

            if node.get("deviceMetrics", {}).get("uptimeSeconds"):
                print(node["deviceMetrics"]["uptimeSeconds"])


        if node.get('position'):
            if node.get("position", {}).get("time"):
                print(node["position"]["time"])

            if node.get("position", {}).get("latitude"):
                print(node["position"]["latitude"])
                print(node["position"]["longitude"])

            if node.get("position", {}).get("altitude"):
                print(node["position"]["altitude"])
"""
node = interface.getNode('^local')
channels = node.channels

# Index: What channel it is on (0-7)
# Role: Disabled (0), Primary (1) or secondary (2)
# PSK: AES key
# Name: Name

if channels:
    print("Channels:")
    for channel in channels:
        if channel.role:
            psk_base64 = base64.b64encode(channel.settings.psk).decode('utf-8')
            print(f"Index: {channel.index}, Role: {channel.role}, PSK (Base64): {psk_base64}, Name: {channel.settings.name}")
            print(channel.settings)
interface.close()
